{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 14:38:07 $                                        =}
{========================================================================}
unit Unit1;

{$I COMPILER.INC}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls, Spin, Menus, Buttons, Gauges, MMSystem,
  MMObj, MMUtils, MMDIBCv, MMOscope, MMWave, MMWaveIO, MMPanel, MMAbout,
  MMWavOut, MMPCMSup, MMCstDlg, MMConect, MMDSPObj;

type
  TMarker = (mkNone,mkBegin,mkEnd);
    
  TMainForm = class(TForm)
    ToolPalette: TPanel;
    FileOpenBtn: TSpeedButton;
    KindBtn1: TSpeedButton;
    KindBtn3: TSpeedButton;
    KindBtn4: TSpeedButton;
    KindBtn2: TSpeedButton;
    KindBtn5: TSpeedButton;
    EffectBtn1: TSpeedButton;
    EffectBtn2: TSpeedButton;
    EffectBtn3: TSpeedButton;
    GainSpin: TSpinEdit;
    RealViewBtn: TSpeedButton;
    FullViewBtn: TSpeedButton;
    ZoomInBtn: TSpeedButton;
    ZoomSpin: TSpinEdit;
    MMPanel1: TMMPanel;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Open1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    View1: TMenuItem;
    N2: TMenuItem;
    DotView1: TMenuItem;
    ConView1: TMenuItem;
    VertView1: TMenuItem;
    MirView1: TMenuItem;
    SpikeView1: TMenuItem;
    Effect1: TMenuItem;
    NoEffect1: TMenuItem;
    PeakEffect1: TMenuItem;
    SplitEffect1: TMenuItem;
    About1: TMenuItem;
    MMWaveFile1: TMMWaveFile;
    ScrollBar1: TScrollBar;
    Oscope1: TMMOscope;
    Oscope2: TMMOscope;
    Oscope4: TMMOscope;
    Oscope3: TMMOscope;
    MMPanel2: TMMPanel;
    MMPanel3: TMMPanel;
    MMPanel4: TMMPanel;
    StatusPanel: TMMPanel;
    Status1: TMMPanel;
    Status2: TMMPanel;
    Status3: TMMPanel;
    Status4: TMMPanel;
    StatusFile: TMMPanel;
    StatusTime: TMMPanel;
    StatusRate: TMMPanel;
    StatusMode: TMMPanel;
    StatusSize: TMMPanel;
    Gauge1: TGauge;
    Image1: TImage;
    Image3: TImage;
    StopBtn: TSpeedButton;
    PauseBtn: TSpeedButton;
    MMWaveOut1: TMMWaveOut;
    PlayBtn: TSpeedButton;
    Timer1: TTimer;
    StatusSample: TMMPanel;
    ScrollBar2: TScrollBar;
    MMWaveOpenDialog1: TMMWaveOpenDialog;
    SaveAs1: TMenuItem;
    MMWaveSaveDialog1: TMMWaveSaveDialog;
    TempFile: TMMWaveFile;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FileOpenBtnClick(Sender: TObject);
    procedure ExitBtnClick(Sender: TObject);
    procedure ViewKindClick(Sender: TObject);
    procedure EffectClick(Sender: TObject);
    procedure GainSpinChange(Sender: TObject);
    procedure FullViewBtnClick(Sender: TObject);
    procedure RealViewBtnClick(Sender: TObject);
    procedure ZoomSpinChange(Sender: TObject);
    procedure ScrollBar1Scroll(Sender: TObject; ScrollCode: TScrollCode;
                               Var ScrollPos: Integer);
    procedure ZoomInBtnClick(Sender: TObject);
    procedure MMPanel1Resize(Sender: TObject);
    procedure OscopeMouseDown(Sender: TObject; Button: TMouseButton;
              Shift: TShiftState; X, Y: Integer);
    procedure OscopeMouseMove(Sender: TObject; Shift: TShiftState; 
                              X, Y: Integer);
    procedure OscopeMouseUp(Sender: TObject; Button: TMouseButton;
                            Shift: TShiftState; X, Y: Integer);
    procedure About1Click(Sender: TObject);
    procedure OscopePostPaint(Sender: TObject);
    procedure PlayBtnBtnClick(Sender: TObject);
    procedure StopBtnClick(Sender: TObject);
    procedure MMWaveOut1Start(Sender: TObject);
    procedure MMWaveOut1Stop(Sender: TObject);
    procedure PauseBtnClick(Sender: TObject);
    procedure MMWaveOut1Pause(Sender: TObject);
    procedure MMWaveOut1Restart(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Timer1Timer(Sender: TObject);
    procedure SaveAs1Click(Sender: TObject);
  private
    procedure WMGetMinMaxInfo(Var Msg: TWMGetMinMaxInfo); message WM_GETMINMAXINFO;
    procedure SaveProgress(Sender: TObject; CurByte, NumBytes: Longint;
                           Var Cancel: Boolean);
  public
    FileIsOpen : Boolean;
    CenterValue: integer;
    BytesPerSample: Byte;
    SamplesPerSBPosition: Longint;
    ReadBuffer: PChar;
    aBitmap: TBitmap;
    aTimer: TTimer;
    Drawing: Boolean;
    Origin,MoveRect: TRect;
    NumSamples, CurSample, FirstSample, LastSample: Longint;
    MarkerBegin, MarkerEnd, PlayPos: Longint;
    CurMarker: TMarker;
    ShowMarker: Boolean;
    FullViewZoomFactor: Longint;
    Resized: Boolean;
    Playing: Boolean;

    function  SamplesPerScope(Sender: TObject): Longint;
    procedure SetupScrollBar;
    procedure AlignScopes;
    function  FmtTimeStr(aSample: Longint): String;
    function  SampleToScreen(SamplePos: Longint): integer;
    function  ScreenToSample(ScreenPos: integer): Longint;
    procedure SetMarked(Redraw: Boolean);
    procedure DrawMarker(Sender: TObject; Marker: TMarker);
    procedure DrawPlayMarker(Sender: TObject);
    procedure DrawPCMData;
    procedure DrawPCMFullViewMono;
    procedure DrawPCMFullViewStereo;
    procedure ScrollTimerExpired(Sender: TObject);
  end;

var
  MainForm: TMainForm;

const
     LargeStep = 50;
     crMark    = 1;
     crZoom    = 2; 

implementation

{$R *.DFM}
{$IFDEF WIN32}
   {$R DISPLY32.RES}
{$ELSE}
   {$R DISPLY.RES}
{$ENDIF}

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.WMGetMinMaxInfo(Var Msg: TWMGetMinMaxInfo);
begin
     with Msg.MinMaxInfo^ do
     begin
           ptMinTrackSize.X := 480;         { Minimum width  }
           ptMinTrackSize.Y := 265;         { Minimum height }
     end;
     Msg.Result := 0;          { Tell windows you have changed minmaxinfo }
     inherited;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.FormCreate(Sender: TObject);
begin
     FileIsOpen := False;
     Drawing := False;
     Playing := False;
     ScrollBar1.Left := 1;
     ScrollBar1.Top := 1;
     ScrollBar1.Align := alBottom;
     ScrollBar2.Align := alRight;
     ReadBuffer := GlobalAllocPtr(GHND, Oscope1.BytesPerScope);
     aTimer := TTimer.Create(Self);
     aTimer.Interval := 50;
     aTimer.Enabled := False;
     aTimer.OnTimer := ScrollTimerExpired;
     Screen.Cursors[crMark] := LoadCursor(HInstance, 'CUR_MARK');
     Screen.Cursors[crZoom] := LoadCursor(HInstance, 'CUR_ZOOM');
     MMWaveFile1.Wave.OnProgress := SaveProgress;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.FormDestroy(Sender: TObject);
begin
     GlobalFreePtr(ReadBuffer);
     aTimer.Free;
     if FileIsOpen then 
     begin
          MMWaveFile1.Wave.CloseFile;
          FileIsOpen := False;
     end;
end;

{-- TMainForm ------------------------------------------------------------}
function TMainForm.SamplesPerScope(Sender: TObject): Longint;
begin
     Result := 0;
     if (Sender is TMMOscope) and (not MMWaveFile1.Wave.Empty) then
     with TMMOscope(Sender), MMWaveFile1.Wave do 
          Result := wioBytesToSamples(@PwaveIOInfo^.wfx, BytesPerScope);
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.SetupScrollBar;
begin
     if FileIsOpen then
     with MMWaveFile1.Wave do
     begin
          ZoomSpin.MaxValue := Max(Round(NumSamples/SamplesPerScope(Oscope1)+0.5),1);
          FullViewZoomFactor := Max(Round(NumSamples/SamplesPerScope(Oscope3)+0.5),1);

          if ((NumSamples div SamplesPerSBPosition > SamplesPerScope(Oscope1))) And
             (ZoomSpin.Value < ZoomSpin.MaxValue) then
          begin
       	       ScrollBar1.Enabled := True;
     	       ScrollBar1.Max := NumSamples div SamplesPerSBPosition;
               ScrollBar1.SmallChange := ZoomSpin.Value;
               ScrollBar1.LargeChange := LargeStep * ZoomSpin.Value;
          end
          else ScrollBar1.Enabled := False;
     end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.FileOpenBtnClick(Sender: TObject);
Var
   aStr: String;

begin
   MMWaveOpenDialog1.FileName := '*.wav';
   if MMWaveOpenDialog1.Execute then
   begin
       with MMWaveFile1.Wave do
       begin
          try
             { close the old file first }
             if FileIsOpen then
             begin
                MMWaveOut1.Stop; 
                MMWaveFile1.Wave.CloseFile;
             end;

             FileIsOpen := False;

             FileName := MMWaveOpenDialog1.Filename;

             { we can only work with PCM files }
             if (FormatTag <> WAVE_FORMAT_PCM) then
                raise EMMWaveError.Create('Invalid wave file...');

             { open the file for reading }
             MMWaveFile1.Wave.OpenFile;

             Oscope1.ResetData;
             Oscope2.ResetData;
             Oscope3.ResetData;
             Oscope4.ResetData;

             Oscope1.Mode := Mode;
             Oscope2.Mode := Mode;
             Oscope3.Mode := Mode;
             Oscope4.Mode := Mode;

             if Mode = mStereo then 
             begin
                aStr := 'Stereo '; 
                Oscope2.Visible := True;
                Oscope4.Visible := True;
                Oscope1.Channel := chLeft;
                Oscope2.Channel := chRight;
                Oscope3.Channel := chLeft;
                Oscope4.Channel := chRight;
             end
             else 
             begin
                aStr := 'Mono '; 
                Oscope2.Visible := False;
                Oscope4.Visible := False;
                Oscope1.Channel := chBoth;
                Oscope2.Channel := chBoth;
                Oscope3.Channel := chBoth;
                Oscope4.Channel := chBoth;
             end;

             case BitLength of
                8 : begin
                       CenterValue := 128;
                       Oscope1.BitLength := b8Bit;
                       Oscope2.BitLength := b8Bit;
                       Oscope3.BitLength := b8Bit;
                       Oscope4.BitLength := b8Bit;
                    end;
                16: begin
                       CenterValue := 0;
                       Oscope1.BitLength := b16Bit;
                       Oscope2.BitLength := b16Bit;
                       Oscope3.BitLength := b16Bit;
                       Oscope4.BitLength := b16Bit;
                    end;
             end;   
                  
             BytesPerSample := wioBytesPerSample(@PWaveIOInfo^.wfx);
             NumSamples := PWaveIOInfo^.dwDataSamples;

             StatusFile.Caption := 'PCM - ' + FileName;
             StatusMode.Caption := aStr + IntToStr(BitLength) + ' bits';
             FmtStr(aStr, '%.2f Sec',[(wioSamplesToTime(@PWaveIOInfo^.wfx, NumSamples) / 1000)]);
             StatusTime.Caption := aStr;
             StatusRate.Caption := IntToStr(SampleRate div 1000) + ' KHz';
             FmtStr(aStr, '%.1f Kb',[(FileSize / 1024)]);
             StatusSize.Caption := aStr;
             StatusSample.Caption := FmtTimeStr(0);
                                        
             SamplesPerSBPosition := 1;
             while (NumSamples div SamplesPerSBPosition) > 32767 do
                   inc(SamplesPerSBPosition);

             ShowMarker := False;

             MarkerBegin := 0;
             MarkerEnd := NumSamples;
             CurSample := 0;
             FirstSample := MarkerBegin;
             LastSample := MarkerEnd;

             ZoomSpin.MaxValue := Round(NumSamples/SamplesPerScope(Oscope1)+0.5);
             ZoomSpin.Value := ZoomSpin.MaxValue;
             ScrollBar1.Position := 0;

             FileIsOpen := True;

             AlignScopes;

             SetMarked(True);

             if MMWaveOut1.NumDevs > 0 then PlayBtn.Enabled := True;
             RealViewBtn.Enabled := True;
             FullViewBtn.Enabled := True;
             ZoomInBtn.Enabled := True;
             GainSpin.Enabled := True;
             ZoomSpin.Enabled := True;
             SaveAs1.Enabled := True;
             Oscope3.Cursor := crZoom;
             Oscope4.Cursor := crZoom;
     
          except
	     on E: Exception do
	        MessageDlg (E.Message, mtError, [mbOK], 0);
          end;
       end;
   end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.SaveAs1Click(Sender: TObject);
begin
   MMWaveSaveDialog1.FileName := '*.wav';
   if MMWaveSaveDialog1.Execute then
   begin
      TempFile.Wave := MMWaveFile1.Wave;
      TempFile.Wave.StartPos := FirstSample;
      TempFile.Wave.EndPos := LastSample;
      TempFile.Wave.Position := 0;
      TempFile.Wave.OnProgress := SaveProgress;

      Gauge1.Align := alNone;
      Gauge1.Left := FirstSample div FullViewZoomFactor +1;
      Gauge1.Width := (LastSample-FirstSample) div FullViewZoomFactor +1;
      Gauge1.Progress := 0;

      TempFile.Wave.SaveToFile(MMWaveSaveDialog1.FileName);

      TempFile.Wave.OnProgress := nil;
      TempFile.Wave.FreeWave;
      Gauge1.Progress := 0;
      Gauge1.Align := alClient;
   end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.SaveProgress(Sender: TObject; CurByte, NumBytes: Longint;
                                 Var Cancel: Boolean);
begin
   Gauge1.Progress := Round((CurByte * 100.0) / NumBytes+0.5);
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.OscopePostPaint(Sender: TObject);
begin
    if FileIsOpen then 
    begin
       if Playing then DrawPlayMarker(Sender); { clear the old PlayMarker }
       DrawMarker(Sender, mkNone);
    end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.DrawPCMData;
var
   i,j,
   CurPos,
   NumRead,
   aResult: Longint;
   TempBufSize: Longint;
   p1, TempBuffer: PChar; 

begin
   if FileIsOpen And (ReadBuffer <> Nil) then
   with MMWaveFile1.Wave do
   begin
      NumRead := 0;
      CurPos := CurSample;
      MMWaveFile1.Wave.Position := CurPos;

      if ZoomSpin.Value = 1 then
         NumRead := ReadDataBytes(ReadBuffer,Oscope1.BytesPerScope)
      else
      begin
         TempBufSize := 1024 * (ZoomSpin.Value * BytesPerSample);
         if TempBufSize <= $FFFF then
         begin
            TempBuffer := GlobalAllocPtr(GHND, TempBufSize);
            try
               p1 := ReadBuffer;
               while (NumRead < Oscope1.BytesPerScope) do
               begin
                  aResult := ReadDataBytes(TempBuffer, TempBufSize);
                  if aResult <= 0 then break;
                  i := 0;
                  while (i < aResult) And (NumRead < Oscope1.BytesPerScope) do
                  begin
                     for j := 0 to BytesPerSample-1 do
                     begin
                        p1^ := (TempBuffer + i + j)^;
                        inc(p1);
                     end;
                     inc(NumRead, BytesPerSample);
                     inc(i, ZoomSpin.Value * BytesPerSample);
                  end;
               end;

            finally
               GlobalFreePtr(TempBuffer);
            end;
         end
         else
         try
            Screen.Cursor := crHourGlass;
            p1 := ReadBuffer;
            while (NumRead < Oscope1.BytesPerScope) do
            begin
               aResult := ReadDataBytes(p1, BytesPerSample);
               if aResult <= 0 then break;
               inc(p1, aResult);
               inc(NumRead, aResult);
               inc(CurPos, ZoomSpin.Value);
               MMWaveFile1.Wave.Position := Min(CurPos,NumSamples);
               if not Playing then
                  Gauge1.Progress := Round((100/Oscope1.BytesPerScope)*NumRead);
            end;

         finally
            Screen.Cursor := crDefault;
            Gauge1.Progress := 0;
         end;
      end;

      if NumRead < 0 then NumRead := 0;

      if (Oscope1.BytesPerScope - NumRead > 0) then
      begin
         p1 := ReadBuffer + NumRead;
         if (BitLength = 8) then
            FillChar(p1^, Oscope1.BytesPerScope - NumRead,128)
         else
            FillChar(p1^, Oscope1.BytesPerScope - NumRead,0);
      end;
   end;
   SetMarked(False);
   Oscope1.RefreshPCMData(ReadBuffer);
   Oscope2.RefreshPCMData(ReadBuffer);
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.DrawPCMFullViewMono;
var
   aSample, aData1, aData2: SmallInt;
   i, j, k, NumRead, aResult: Longint;
   TempBufSize: Longint;
   p1, TempBuffer: PChar;

begin
   if FileIsOpen And (ReadBuffer <> Nil) then
   with MMWaveFile1.Wave do
   begin
      NumRead := 0;
      MMWaveFile1.Wave.Position := 0;

      TempBufSize := Min(PWaveIOInfo^.dwDataBytes, $FFFC);
      TempBuffer := GlobalAllocPtr(GHND, TempBufSize);
      try
         if TempBufSize >= $FFF then Screen.Cursor := crHourGlass;
         p1 := ReadBuffer;
         aResult := ReadDataBytes(TempBuffer, TempBufSize);
         i := 0;
         while (i < aResult) And (NumRead < Oscope3.BytesPerScope) do
         begin
            aData1 := 0;
            aData2 := 0;
            j := 0;
            for k := 1 to FullViewZoomFactor do
            begin
               if i + j + BytesPerSample >= aResult then
               begin
                  aResult := ReadDataBytes(TempBuffer, TempBufSize);
                  if aResult < BytesPerSample then
                  begin
                     j := -1;
                     break;
                  end;
                  i := 0;
                  j := 0;
               end;

               case BytesPerSample of
                    1: aSample := PByte(TempBuffer + i + j)^-CenterValue;
                    2: aSample := PSmallInt(TempBuffer + i + j)^-CenterValue;
               end;

               if aSample < 0 then begin
                  if aSample < aData1 then aData1 := aSample; end
               else begin
                  if aSample > aData2 then aData2 := aSample; end;

               inc(j, BytesPerSample);
            end;

            if j > 0 then
            begin
               if abs(aData1) > abs(aData2) then aSample := aData1
               else aSample := aData2;

               case BytesPerSample of
                    1: PByte(p1)^ := aSample+CenterValue;
                    2: PSmallInt(p1)^ := aSample+CenterValue;
               end;

               inc(p1, BytesPerSample);
               inc(NumRead, BytesPerSample);
            end
            else j := k;

            inc(i, j);
            Gauge1.Progress := Round((100/Oscope3.BytesPerScope)*NumRead);
         end;

      finally
         GlobalFreePtr(TempBuffer);
         Screen.Cursor := crDefault;
         Gauge1.Progress := 0;
      end;

      if NumRead < 0 then NumRead := 0;

      if (Oscope3.BytesPerScope - NumRead > 0) then
      begin
         p1 := ReadBuffer + NumRead;
         if (BitLength = 8) then
            FillChar(p1^, Oscope3.BytesPerScope - NumRead,128)
         else
            FillChar(p1^, Oscope3.BytesPerScope - NumRead,0);
      end;
   end;
   SetMarked(False);
   Oscope3.RefreshPCMData(ReadBuffer);
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.DrawPCMFullViewStereo;
var
   aSampleL, aSampleR, aDataL1, aDataL2, aDataR1, aDataR2: SmallInt;
   i, j, k, NumRead, aResult: Longint;
   TempBufSize: Longint;
   p1, TempBuffer: PChar;

begin
   if FileIsOpen And (ReadBuffer <> Nil) then
   with MMWaveFile1.Wave do
   begin
      NumRead := 0;
      MMWaveFile1.Wave.Position := 0;

      TempBufSize := Min(PWaveIOInfo^.dwDataBytes, $FFFC);
      TempBuffer := GlobalAllocPtr(GHND, TempBufSize);
      try
         if TempBufSize = $FFFC then Screen.Cursor := crHourGlass;
         p1 := ReadBuffer;
         aResult := ReadDataBytes(TempBuffer, TempBufSize);
         i := 0;
         while (i < aResult) And (NumRead < Oscope3.BytesPerScope) do
         begin
            aDataL1 := 0;
            aDataL2 := 0;
            aDataR1 := 0;
            aDataR2 := 0;
            j := 0;
            for k := 1 to FullViewZoomFactor do
            begin
               if i + j + BytesPerSample >= aResult then
               begin
                  aResult := ReadDataBytes(TempBuffer, TempBufSize);
                  if aResult < BytesPerSample then
                  begin
                     j := -1;
                     break;
                  end;
                  i := 0;
                  j := 0;
               end;

               case BytesPerSample of
                    2: begin
                          aSampleL := PByte(TempBuffer + i + j)^-CenterValue;
                          aSampleR := PByte(TempBuffer + i + j + 1)^-CenterValue;
                          end;
                    4: begin
                          aSampleL := PSmallInt(TempBuffer+i+j)^-CenterValue;
                          aSampleR := PSmallInt(TempBuffer+i+j+2)^-CenterValue;
                       end;
               end;

               if aSampleL < 0 then begin
                  if aSampleL < aDataL1 then aDataL1 := aSampleL; end
               else begin
                  if aSampleL > aDataL2 then aDataL2 := aSampleL; end;

               if aSampleR < 0 then begin
                  if aSampleR < aDataR1 then aDataR1 := aSampleR; end
               else begin
                  if aSampleR > aDataR2 then aDataR2 := aSampleR; end;

               inc(j, BytesPerSample);
            end;

            if j > 0 then
            begin
               if abs(aDataL1) > abs(aDataL2) then aSampleL := aDataL1
               else aSampleL := aDataL2;

               if abs(aDataR1) > abs(aDataR2) then aSampleR := aDataR1
               else aSampleR := aDataR2;

               case BytesPerSample of
                    2: begin
                          PByte(p1)^ := aSampleL + CenterValue;
                          PByte(p1+1)^ := aSampleR + CenterValue;
                       end;
                    4: begin
                          PSmallInt(p1)^ := aSampleL + CenterValue;
                          PSmallInt(p1+2)^ := aSampleR + CenterValue;
                       end;
               end;

               inc(p1, BytesPerSample);
               inc(NumRead, BytesPerSample);
            end
            else j := k;

            inc(i, j);
            Gauge1.Progress := Round((100/Oscope3.BytesPerScope)*NumRead);
         end;

      finally
         GlobalFreePtr(TempBuffer);
         Screen.Cursor := crDefault;
         Gauge1.Progress := 0;
      end;

      if NumRead < 0 then NumRead := 0;

      if (Oscope3.BytesPerScope - NumRead > 0) then
      begin
         p1 := ReadBuffer + NumRead;
         if (BitLength = 8) then
            FillChar(p1^, Oscope3.BytesPerScope - NumRead,128)
         else
            FillChar(p1^, Oscope3.BytesPerScope - NumRead,0);
      end;
   end;
   SetMarked(False);
   Oscope3.RefreshPCMData(ReadBuffer);
   Oscope4.RefreshPCMData(ReadBuffer);
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.ExitBtnClick(Sender: TObject);
begin
     Close;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.ViewKindClick(Sender: TObject);
begin
     DotView1.Checked := False;
     ConView1.Checked := False;
     VertView1.Checked := False;
     MirView1.Checked := False;
     SpikeView1.Checked := False;

     if (Sender = DotView1) OR (Sender = KindBtn1) then
     begin
          Oscope1.Kind := okDots;
          Oscope2.Kind := okDots;
          KindBtn1.Down := True;
          DotView1.Checked := True;
     end
     else if (Sender = ConView1) OR (Sender = KindBtn2) then
     begin
          Oscope1.Kind := okConLines;
          Oscope2.Kind := okConLines;
          KindBtn2.Down := True;
          ConView1.Checked := True;
     end
     else if (Sender = VertView1) OR (Sender = KindBtn3) then
     begin
          Oscope1.Kind := okVertLines;
          Oscope2.Kind := okVertLines;
          KindBtn3.Down := True;
          VertView1.Checked := True;
     end
     else if (Sender = MirView1) OR (Sender = KindBtn4) then
     begin
          Oscope1.Kind := okMirLines;
          Oscope2.Kind := okMirLines;
          KindBtn4.Down := True;
          MirView1.Checked := True;
     end
     else if (Sender = SpikeView1) OR (Sender = KindBtn5) then
     begin
          Oscope1.Kind := okSpikes;
          Oscope2.Kind := okSpikes;
          KindBtn5.Down := True;
          SpikeView1.Checked := True;
     end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.EffectClick(Sender: TObject);
begin
     NoEffect1.Checked := False;
     PeakEffect1.Checked := False;
     SplitEffect1.Checked := False;

     if (Sender = NoEffect1) OR (Sender = EffectBtn1) then
     begin
          Oscope1.Effect := efNone;
          Oscope2.Effect := efNone;
          EffectBtn1.Down := True;
          NoEffect1.Checked := True;
     end
     else if (Sender = PeakEffect1) OR (Sender = EffectBtn2) then
     begin
          Oscope1.Effect := efPeak;
          Oscope2.Effect := efPeak;
          EffectBtn2.Down := True;
          PeakEffect1.Checked := True;
     end
     else if (Sender = SplitEffect1) OR (Sender = EffectBtn3) then
     begin
          Oscope1.Effect := efSplit;
          Oscope2.Effect := efSplit;
          EffectBtn3.Down := True;
          SplitEffect1.Checked := True;
     end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.GainSpinChange(Sender: TObject);
begin
     Oscope1.Gain := GainSpin.Value;
     Oscope2.Gain := GainSpin.Value;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.AlignScopes;
Var
   aHeight: integer;

begin
     if Not Resized then
     begin
        Resized := True;
        ShowMarker := False;
        aHeight := MMPanel1.Height - (2 * MMPanel1.BevelExtend);
        if Oscope2.Visible then Oscope2.Height := aHeight div 2
        else Oscope2.Height := 1;

        aHeight := MMPanel3.Height - (2 * MMPanel3.BevelExtend);
        if Oscope4.Visible then Oscope4.Height := aHeight div 2
        else Oscope4.Height := 1;

        Gauge1.Progress := 0;
        Gauge1.Align := alClient;

        GlobalFreePtr(ReadBuffer);
        ReadBuffer := GlobalAllocPtr(GHND,Max(Oscope1.BytesPerScope,Oscope3.BytesPerScope));
        if FileIsOpen then
        begin
             Application.ProcessMessages;
             SetupScrollBar;
             ShowMarker := True;
             if MMWaveFile1.Wave.Mode = mMono then DrawPCMFullViewMono
             else DrawPCMFullViewStereo;
             DrawPCMData;
             if Playing then
             begin
                Gauge1.Align := alNone;
                Gauge1.Left := FirstSample div FullViewZoomFactor +1;
                Gauge1.Width := (LastSample-FirstSample) div FullViewZoomFactor +1;
             end;
        end;
   end;
   Resized := False;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMPanel1Resize(Sender: TObject);
begin
     AlignScopes;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.FullViewBtnClick(Sender: TObject);
begin
     if FileIsOpen then
     begin
          CurSample := 0;
          ScrollBar1.Position := 0;
          ZoomSpin.Value := ZoomSpin.MaxValue;  
     end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.RealViewBtnClick(Sender: TObject);
begin
     if FileIsOpen then
        ZoomSpin.Value := 1;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.ZoomSpinChange(Sender: TObject);
begin
     if FileIsOpen And (ZoomSpin.Value > 0) then 
     begin
          SetupScrollBar;
          DrawPCMData;
     end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.ScrollBar1Scroll(Sender: TObject; ScrollCode: TScrollCode;
                                     Var ScrollPos: Integer);
const
     Tracking: Boolean = False;

begin
     case ScrollCode of
         scLineUp,
         scLineDown,
         scPageUp,
         scPageDown: if ScrollPos * SamplesPerSBPosition <> CurSample then
                     begin
                          CurSample := ScrollPos * SamplesPerSBPosition;
                          DrawPCMData;
                     end;     
            scTrack: if ScrollPos * SamplesPerSBPosition <> CurSample then
                     begin
                          ScrollPos := ScrollPos div ScrollBar1.SmallChange * ScrollBar1.SmallChange;
                          Tracking := True; 
                          CurSample := ScrollPos * SamplesPerSBPosition;
                          DrawPCMData;
                     end;
        scEndScroll: if Tracking then ScrollPos := CurSample div SamplesPerSBPosition;
     end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.ZoomInBtnClick(Sender: TObject);
Var
   aPos,aZoom: Longint;

begin
   if FileIsOpen then
   begin
      aPos := CurSample;
      aZoom := Max(Round((LastSample - FirstSample)/SamplesPerScope(Oscope1)+0.5),1);

      if ((LastSample - CurSample) div aZoom > Oscope1.Width) or
         ((FirstSample - CurSample) div aZoom < 0) then
      begin
         aPos := FirstSample;
         ScrollBar1.Position := aPos div SamplesPerSBPosition;
      end;

      if (aZoom <> ZoomSpin.Value) then
      begin
         CurSample := aPos;
         ZoomSpin.Value := aZoom;
      end
      else if (CurSample <> aPos) then
      begin
         CurSample := aPos;
         DrawPCMData;
      end;
   end;
end;

{-- TMainForm ------------------------------------------------------------}
function TMainForm.SampleToScreen(SamplePos: Longint): integer;
Var
   aResult: Longint;

begin
     SamplePos := Min(SamplePos, NumSamples);
     SamplePos := Max(SamplePos, 0);
     aResult := (SamplePos - CurSample) div ZoomSpin.Value;
     aResult := Min(aResult,Oscope1.Width+10);
     Result := Max(aResult,-10);
end;

{-- TMainForm ------------------------------------------------------------}
function TMainForm.ScreenToSample(ScreenPos: integer): Longint;
begin
     ScreenPos := Min(ScreenPos, Oscope1.Width-1);
     ScreenPos := Max(ScreenPos, 0);
     Result := CurSample + (ScreenPos * ZoomSpin.Value);
     Result := Min(Result,NumSamples);
     Result := Max(Result,0);
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.SetMarked(Redraw: Boolean);
begin
     if Oscope1.Visible then
        Oscope1.Marked(SampleToScreen(FirstSample), 
                       SampleToScreen(LastSample),
                       Redraw);

     if Oscope2.Visible then
        Oscope2.Marked(SampleToScreen(FirstSample), 
                       SampleToScreen(LastSample),
                       Redraw);

     if Oscope3.Visible then
        Oscope3.Marked(FirstSample div FullViewZoomFactor, 
                       LastSample div FullViewZoomFactor,
                       Redraw);

     if Oscope4.Visible then
        Oscope4.Marked(FirstSample div FullViewZoomFactor, 
                       LastSample div FullViewZoomFactor,
                       Redraw);
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.DrawMarker(Sender: TObject; Marker: TMarker);
Var
   aPos: integer;

begin
   if (Sender is TMMOscope) And ShowMarker then
   begin
      if TMMOscope(Sender).Visible then
      with TMMOscope(Sender), TMMOscope(Sender).Canvas do
      begin
         Pen.Color := clMaroon;
         Pen.Mode := pmNotXor; 

         if (Marker = mkNone) or (Marker = mkBegin) then
         begin
            if (Sender = Oscope3) or (Sender = Oscope4) then
               aPos := FirstSample div FullViewZoomFactor
            else aPos := SampleToScreen(MarkerBegin);
            MoveTo(aPos, 0);
            LineTo(aPos, Height);
         end;

         if (Marker = mkNone) or (Marker = mkEnd) then
         begin
            if (Sender = Oscope3) or (Sender = Oscope4) then
               aPos := LastSample div FullViewZoomFactor
            else aPos := SampleToScreen(MarkerEnd);
            MoveTo(aPos, 0);
            LineTo(aPos, Height);
         end;
      end;
   end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.DrawPlayMarker(Sender: TObject);
Var
   aPos: integer;

begin
   if (Sender is TMMOscope) And ShowMarker then
   begin
      if TMMOscope(Sender).Visible then
      with TMMOscope(Sender), TMMOscope(Sender).Canvas do
      begin
         Pen.Color := clNavy;
         Pen.Mode := pmNotXor;

         if (Sender = Oscope3) or (Sender = Oscope4) then
               aPos := PlayPos div FullViewZoomFactor
         else aPos := SampleToScreen(PlayPos);

         if aPos > 0 then
         begin
            MoveTo(aPos, 0);
            LineTo(aPos, Height);
         end;
      end;
   end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.ScrollTimerExpired(Sender: TObject); 

Var
   MousePos: TPoint;
   aPos, aMin, aMax: Longint;
   
begin
   GetCursorPos(MousePos);
   MousePos := Oscope1.ScreenToClient(MousePos);

   with ScrollBar1 do
   begin
      if CurMarker = mkBegin then
      begin
         aMin := 0;
         aMax := MarkerEnd-((Oscope1.Width-1)*ZoomSpin.Value)-1;
      end
      else if CurMarker = mkEnd then 
      begin
         aMin := MarkerBegin+1;
         aMax := NumSamples-((Oscope1.Width-1)*ZoomSpin.Value);
      end;

      if (MousePos.X < 0) then
      begin
         if (MousePos.X < -5) then 
            aPos := MMUtils.Max(CurSample - 4*LargeChange,aMin)
         else if (MousePos.X < -2) then
            aPos := MMUtils.Max(CurSample - LargeChange,aMin)
         else
            aPos := MMUtils.Max(CurSample - SmallChange,aMin);
      end
      else 
      if (MousePos.X >= Oscope1.Width) then
      begin
         if (MousePos.X > Oscope1.Width+4) then 
            aPos := MMUtils.Min(CurSample + 4*LargeChange, aMax)
         else if (MousePos.X > Oscope1.Width+1) then
            aPos := MMUtils.Min(CurSample + LargeChange, aMax)
         else
            aPos := MMUtils.Min(CurSample + SmallChange, aMax);
      end
      else aPos := CurSample;

      if (CurSample <> aPos) then
      begin
         CurSample := aPos;
         Position := aPos div SamplesPerSBPosition;

         if CurMarker = mkBegin then 
         begin
            MarkerBegin := ScreenToSample(MousePos.X);
            StatusSample.Caption := FmtTimeStr(MarkerBegin);
         end
         else if CurMarker = mkEnd then 
         begin
            MarkerEnd := ScreenToSample(MousePos.X);
            StatusSample.Caption := FmtTimeStr(MarkerEnd);
         end;
            
         DrawPCMData;
      end 
      else aTimer.Enabled := False;
   end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.OscopeMouseDown(Sender: TObject; Button: TMouseButton;
          Shift: TShiftState; X, Y: Integer);
begin
     if FileIsOpen And (Not Drawing) And (Not Playing) then
     begin
        if (Sender = Oscope1) or (Sender = Oscope2) then
        begin
           if (Button = mbLeft) then
           begin
              if (X >= SampleToScreen(MarkerBegin)-5) and
                 (X <= SampleToScreen(MarkerBegin)+5) and
                 (X < SampleToScreen(MarkerEnd)) then 
              begin
                 Drawing := True;                     
                 CurMarker := mkBegin;
                 StatusSample.Caption := FmtTimeStr(MarkerBegin);
              end
              else 
              if (X >= SampleToScreen(MarkerEnd)-5) and 
                 (X <= SampleToScreen(MarkerEnd)+5) then
              begin
                 Drawing := True;                     
                 CurMarker := mkEnd;
                 StatusSample.Caption := FmtTimeStr(MarkerEnd);
              end
              else if (X < SampleToScreen(MarkerEnd)) then
              begin
                 MarkerBegin := ScreenToSample(X);
                 FirstSample := MarkerBegin;
                 SetMarked(True);
                 StatusSample.Caption := FmtTimeStr(MarkerBegin);
              end;
           end
           else if (Button = mbRight) and (X > SampleToScreen(MarkerBegin)) then 
           begin
                MarkerEnd := ScreenToSample(X);
                LastSample := MarkerEnd;
                SetMarked(True);
                StatusSample.Caption := FmtTimeStr(MarkerEnd);
           end;
        end
        else 
        if ((Sender = Oscope3) or (Sender = Oscope4)) and (Button = mbLeft) then
        begin
           Drawing := True;                     
           aBitmap := TBitmap.Create;
           aBitmap.Width := Max(Oscope3.Width,Oscope4.Width);
           aBitmap.Height := Max(Oscope3.Height,Oscope4.Height);
           with aBitmap do
           begin
              Canvas.Brush.Color := Oscope3.Color;  
              Canvas.FillRect(Rect(0,0,Width,Height));
           end;
           Oscope3.Canvas.CopyMode := cmNotSrcErase;
           Oscope4.Canvas.CopyMode := cmNotSrcErase;
           Origin := Rect(X, 0, X+1, aBitmap.Height);
           MoveRect := Origin;
           Oscope3.Canvas.CopyRect(MoveRect, aBitmap.Canvas, MoveRect);
           if Oscope4.Visible then
              Oscope4.Canvas.CopyRect(MoveRect, aBitmap.Canvas, MoveRect);
           MoveRect.Left := MoveRect.Right;
           StatusSample.Caption := FmtTimeStr(X * FullViewZoomFactor);
        end;
     end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.OscopeMouseMove(Sender: TObject; Shift: TShiftState;
          X, Y: Integer);
Var
   aSamples: Longint;
begin
     if Drawing then
     begin
        if (Sender=Oscope1) or (Sender=Oscope2) and (Not aTimer.Enabled) then
        begin                  
           if (X < 0) and (CurSample > 0) then
           begin
              if (MarkerEnd <= MarkerBegin+1) then exit;
              X := 0;
              aTimer.Enabled := True;
           end                 
           else if (X >= Oscope1.Width) then 
           begin
              if (MarkerBegin >= MarkerEnd-1) then exit;
              X := Oscope1.Width-1;
              if (CurSample+((Oscope1.Width)*ZoomSpin.Value) < NumSamples) then
              aTimer.Enabled := True;
           end;

           if (CurMarker = mkBegin) then
           begin
              if (X >= SampleToScreen(MarkerEnd)) then 
                  X := SampleToScreen(MarkerEnd)-1;

              if (X < 0) then X := 0; 
              
              if (X <> SampleToScreen(MarkerBegin)) then
              begin
                 DrawMarker(Oscope1, CurMarker);
                 DrawMarker(Oscope2, CurMarker);
                 MarkerBegin := ScreenToSample(X);
                 DrawMarker(Oscope1, CurMarker);
                 DrawMarker(Oscope2, CurMarker);
                 StatusSample.Caption := FmtTimeStr(MarkerBegin);
              end;
           end
           else if (CurMarker = mkEnd) then
           begin
              if (X <= SampleToScreen(MarkerBegin)) then 
                  X := SampleToScreen(MarkerBegin)+1;

              if (X > SampleToScreen(NumSamples)) then 
                  X := SampleToScreen(NumSamples); 
              
              if (X <> SampleToScreen(MarkerEnd)) then
              begin
                 DrawMarker(OScope1, CurMarker);
                 DrawMarker(OScope2, CurMarker);
                 MarkerEnd := ScreenToSample(X);
                 DrawMarker(Oscope1, CurMarker);
                 DrawMarker(OScope2, CurMarker);
                 StatusSample.Caption := FmtTimeStr(MarkerEnd);
              end;
           end;
        end
        else 
        if (Sender = Oscope3) or (Sender = Oscope4) then
        begin
           MoveRect.Right := X + 1;
           Oscope3.Canvas.CopyRect(MoveRect, aBitmap.Canvas, MoveRect);
           if Oscope4.Visible then
              Oscope4.Canvas.CopyRect(MoveRect, aBitmap.Canvas, MoveRect);
           MoveRect.Left := MoveRect.Right;

           if (X < 0) then X := 0
           else if X >= Oscope3.Width then X := Oscope3.Width-1;

           if (X = Origin.Left) then aSamples := X * FullViewZoomFactor
           else aSamples := (abs(Origin.Left-X)+1) * FullViewZoomFactor;
           StatusSample.Caption := FmtTimeStr(aSamples);
        end;
     end
     else if FileIsOpen and (Not Playing) then
     begin
          if (Sender = Oscope1) or (Sender = Oscope2) then
          begin
             if ((X >= SampleToScreen(MarkerBegin)-5) and 
                 (X <= SampleToScreen(MarkerBegin)+5)) or 
                ((X >= SampleToScreen(MarkerEnd)-5) and 
                 (X <= SampleToScreen(MarkerEnd)+5)) then
             begin
                Oscope1.Cursor := crMark;
                Oscope2.Cursor := crMark;
             end
             else if (Oscope1.Cursor <> crDefault) then
             begin
                Oscope1.Cursor := crDefault;
                Oscope2.Cursor := crDefault;
             end;
          end;
     end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.OscopeMouseUp(Sender: TObject; Button: TMouseButton;
          Shift: TShiftState; X, Y: Integer);
Var
   aPos,aZoom: Longint;

begin
     if Drawing and (Button = mbLeft) then
     begin
        if (Sender = Oscope1) or (Sender = Oscope2) then
        begin
           aTimer.Enabled := False;
           Drawing := False;
           CurMarker := mkNone;
           FirstSample := MarkerBegin;
           LastSample := MarkerEnd;
           SetMarked(True);
        end
        else 
        if (Sender = Oscope3) or (Sender = Oscope4) then
        begin
           Origin.Right := MoveRect.Right;
           Oscope3.Canvas.CopyRect(Origin, aBitmap.Canvas, Origin);
           if Oscope4.Visible then
              Oscope4.Canvas.CopyRect(Origin, aBitmap.Canvas, Origin);
           Drawing := False;
           aBitmap.Free;

           if X < 0 then X := 0
           else if X > Oscope3.Width then X := Oscope3.Width;
           
           aPos := Min(Origin.Left,X) * FullViewZoomFactor;
           if CurSample <> aPos then
              ScrollBar1.Position := aPos div SamplesPerSBPosition;

           if abs(Origin.Left - X) > 0 then
           begin
              if (X < Origin.Left) then inc(Origin.Left);
              aZoom := Max(Round((abs(Origin.Left-X)+1)*
                       (NumSamples/SamplesPerScope(Oscope3))
                        /SamplesPerScope(Oscope1)+0.5),1);
           end
           else aZoom := 1;

           if (aZoom <> ZoomSpin.Value) then
           begin
              CurSample := aPos;
              ZoomSpin.Value := aZoom;
           end
           else if CurSample <> aPos then
           begin
              CurSample := aPos;
              DrawPCMData;
           end;
        end
     end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
     MMWaveOut1.Close;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.About1Click(Sender: TObject);
begin
     Show_AboutBox(0);
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.PlayBtnBtnClick(Sender: TObject);
Var
   aState: TMMWaveOutState;

begin
     try
        aState := MMWaveOut1.State;
        if (wosPause in aState) AND (wosPlay in aState) then
           MMWaveOut1.Restart
        else if Not (wosPlay in aState )then
        begin
           TempFile.Wave.FileName := MMWaveFile1.Wave.FileName;
           TempFile.Wave.StartPos := FirstSample;
           TempFile.Wave.EndPos := LastSample;
           TempFile.Wave.Position := 0;

           Gauge1.Align := alNone;
           Gauge1.Left := FirstSample div FullViewZoomFactor +1;
           Gauge1.Width := (LastSample-FirstSample) div FullViewZoomFactor +1;
           MMWaveOut1.Start;
        end;

        if (wosPlay in MMWaveOut1.State) then
           PlayBtn.Down := True;

     except
        PlayBtn.Down := False;
        raise
     end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.PauseBtnClick(Sender: TObject);
Var
   aState: TMMWaveOutState;
begin
     aState := MMWaveOut1.State;
     if (wosPlay in aState) then
        if not (wosPause in aState) then MMWaveOut1.Pause
        else if (wosPause in aState) then MMWaveOut1.Restart;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.StopBtnClick(Sender: TObject);
begin
     Playing := False;
     MMWaveOut1.Stop;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMWaveOut1Start(Sender: TObject);
begin
     Playing := True;
     StopBtn.Enabled := True;
     PauseBtn.Enabled := True;
     PlayPos := -1;

     Timer1.Enabled := True;
    
     Oscope3.Cursor := crDefault;
     Oscope4.Cursor := crDefault;
     
     RealViewBtn.Enabled := False;
     ZoomInBtn.Enabled := False;
     FullViewBtn.Enabled := False;
     ScrollBar1.Enabled := False;
     ZoomSpin.Enabled := False;
     GainSpin.Enabled := False;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMWaveOut1Pause(Sender: TObject);
begin
     PlayBtn.Down := False;
     PauseBtn.Down := True;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMWaveOut1Restart(Sender: TObject);
begin
     PlayBtn.Down := True;
     PauseBtn.Down := False;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMWaveOut1Stop(Sender: TObject);
begin
     Timer1.Enabled := False;
     MMWaveOut1.Close;
     TempFile.Wave.FreeWave;
     if Playing then
     begin
        Playing := False;
        StatusSample.Caption := FmtTimeStr(0)
     end;
     PlayBtn.Down := False;
     StopBtn.Enabled := False;
     PauseBtn.Enabled := False;
     Oscope3.Cursor := crZoom;
     Oscope4.Cursor := crZoom;
     RealViewBtn.Enabled := True;
     ZoomInBtn.Enabled := True;
     FullViewBtn.Enabled := True;
     ZoomSpin.Enabled := True;
     GainSpin.Enabled := True;
     SetupScrollBar;
     ScrollBar1.Position := CurSample div SamplesPerSBPosition;
     Gauge1.Progress := 0;
     Gauge1.Align := alClient;
     DrawPlayMarker(Oscope1);     { clear the play marker }
     DrawPlayMarker(Oscope2);
     DrawPlayMarker(Oscope3);     { clear the play marker }
     DrawPlayMarker(Oscope4);
end;

{-- TMainForm ------------------------------------------------------------}
Function TMainForm.FmtTimeStr(aSample: Longint): String;
begin
     Result := TimeToString(wioSamplesToTime(@MMWaveFile1.Wave.PWaveIOInfo^.wfx, aSample));
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.Timer1Timer(Sender: TObject);
Var
   oldPlayPos,aPosition: Longint;

begin
     if Playing then
     with MMWaveOut1 do
     begin
        aPosition := Position;
        if (aPosition > 0) then
        begin
           Gauge1.Progress := Round((100/(LastSample-FirstSample))*aPosition);

           inc(aPosition, FirstSample);
           StatusSample.Caption := FmtTimeStr(aPosition);

           if PlayPos div FullViewZoomFactor <> aPosition div FullViewZoomFactor then
           begin
              oldPlayPos := PlayPos;
              DrawPlayMarker(Oscope3);         { clear the old PlayMarker }
              DrawPlayMarker(Oscope4);
              PlayPos := aPosition;
              DrawPlayMarker(Oscope3);
              DrawPlayMarker(Oscope4);
              PlayPos := oldPlayPos;
           end;

           if SampleToScreen(PlayPos) <> SampleToScreen(aPosition) then
           begin
              if (SampleToScreen(aPosition) >= Oscope1.Width) and
                 (1024 * ZoomSpin.Value * BytesPerSample <= $FFFF)  then
              begin
                 CurSample := aPosition;
                 DrawPCMData;
              end
              else
              begin
                 DrawPlayMarker(Oscope1);      { clear the old PlayMarker }
                 DrawPlayMarker(Oscope2);
              end;
              PlayPos := aPosition;
              DrawPlayMarker(Oscope1);
              DrawPlayMarker(Oscope2);
           end;
           PlayPos := aPosition;
        end
        else StatusSample.Caption := FmtTimeStr(0)
     end;
end;

end.
